import sys

sys.setrecursionlimit(200000)

def is_prefix(u, v):
    u_str = str(u)
    v_str = str(v)
    return len(u_str) < len(v_str) and v_str.startswith(u_str)

def solve():
    n = int(sys.stdin.readline())
    a = list(map(int, sys.stdin.readline().split()))
    
    adj = [[] for _ in range(n)]
    for i in range(n):
        for j in range(n):
            if i != j and is_prefix(a[i], a[j]):
                adj[i].append(j)

    match1 = [-1] * n
    match2 = [-1] * n
    visited = [False] * n

    def dfs_match(u):
        if visited[u]:
            return False
        visited[u] = True
        for v in adj[u]:
            if match2[v] == -1 or dfs_match(match2[v]):
                match2[v] = u
                match1[u] = v
                return True
        return False

    matching_size = 0
    for i in range(n):
        visited = [False] * n
        if dfs_match(i):
            matching_size += 1

    k = n - matching_size
    print(k)

    in_match2 = set(match2)
    path_starts = [i for i in range(n) if i not in in_match2]

    for start_node_idx in path_starts:
        path = []
        curr = start_node_idx
        while curr != -1:
            path.append(a[curr])
            curr = match1[curr]
        print(len(path))
        print(*path)

solve()